/*-----------------------------------------------------------------------------------------------------------------------------
FileName: XYDetector.h 
Autors: Mathieu Gisselbrecht
Date : Creation -  Septembre 2006
-----------------------------------------------------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------------------------------------------------------
// MISC #DEFINEs
//-----------------------------------------------------------------------------------------------------------------------------
#define N_HITS_MAX				20
#define NB_MAX_DS16				8
#define NB_XY_CHANNEL			NB_MAX_DS16*16	

//-----------------------------------------------------------------------------------------------------------------------------
//  TYPEDEF AND STRUCTURE : PIXEL-LINE DETECTOR EVENT ANALYZER
//-----------------------------------------------------------------------------------------------------------------------------
// Structure used to analyze the hits in the event: number of hits in x and y...
typedef struct {	
	// -------------- Specific for  pixel-line detector --------------
	long 			numChannelBits, xyBit, numDS16Bits;			// Significant bits to treat event data
	long 	 		nx, ny, nxy;													// Number of hit in x, y and (x,y) per event
	long 	 		time[N_HITS_MAX];    											// TDC time and channel per event
	long 			channelx[N_HITS_MAX],channely[N_HITS_MAX];		
	// -------------- Specific for  other detector --------------
	// ....
} TXYEvent;

//-----------------------------------------------------------------------------------------------------------------------------
// TYPEDEF AND STRUCTURE : PIXEL-LINE DETECTOR
//-----------------------------------------------------------------------------------------------------------------------------
typedef struct {
	long			nbDS16, anode, deltaT, lostpixel;
	DOUBLE			pixelsize;
	long 			DS16Area[NB_MAX_DS16],nbHits[MAXCOINCIDENCEORDER][N_HITS_MAX];	// Hit distribution in single, double coincidence... 

	long 			DS16Offset[NB_MAX_DS16],channelOffset[16][NB_MAX_DS16];	
	long			refTdc, ref, ch[3]; 
		
	TXYEvent 		Event;								// Event structure to analyze hits 

} TXYDetector;

//-----------------------------------------------------------------------------------------------------------------------------
// PROTOTYPES : PIXEL-LINE DETECTOR -> CIEL 1 & CIEL 2
//-----------------------------------------------------------------------------------------------------------------------------
void InitXYEvent(TDetector *Detector);
short addXYEvent(TDetector *Detector, long tdcTime, long tdcChannel);
short correctXYEvent(TDetector *Detector);
short localizedXYEvent(TDetector *Detector);

//-----
short createXYDetector(TDetector *Detector, 
		long nbDS16, long anode, long deltaT, long lostpixel, float pixelsize, long ref, long ch1, long ch2);
short updateXYDetector(TDetector *Detector, int mode);		
short setigorXYDetector(TDetector *Detector);
short getigorXYDetector(TDetector *Detector);